﻿/*****************************************************************************************************
* $$FileName		Update Index.jsx
*
* $$Description		Sample ExtendScript file to create a new index file according to the tags specified in the styleArray
*
* Copyright (c) 2009 Adobe Systems Incorporated. All Rights Reserved.
******************************************************************************************************/

//global variables
var styleArray = new Array();
var newIndexFileName = "SampleIndex";	// this is the sample index file which will be created every time.
var indexArray = new Array();	//array to save all the indexes we found

//this is the place where you would want to modify the script file to add more heading to the script file
styleArray[styleArray.length] = '<h1>';
styleArray[styleArray.length] = '<h3>';

main();

function main()
{
	var topicmanager = RoboHelp.project.TopicManager;
	var topic;
	for(var index=1;index<=topicmanager.count;index++)
	{
		topic = topicmanager.item(index);
		//we need update the topic now.
		ReadTopicForIndexes(topic);
	}
	outputMsg('Updating the Index File now\n');
	UpdateIndexFile();
	alert('Updating done, Project will close and reopen again');
	CloseAndReopen();
}

function outputMsg(szString)
{
	RoboHelp.project.outputMessage (szString);
}

function ReadTopicForIndexes(topic)
{
	var filepath = topic.path;
	var msg = 'Reading Topic   '+topic.name+'\n';
	outputMsg(msg);

//this is to get the token manager for the topic specified.
	var tokenmgr = RoboHelp.getTokenManager(filepath);

	if(typeof(tokenmgr)!='undefined')
	{
		if(tokenmgr.count>0)
		{
			var token = tokenmgr.item(1);
			while(typeof(token)!='undefined')
			{
				//we have the token we need to check if this is the one we are worried about
				if(token.tokenType ==RoboHelp.TokenType.TOKENTAG && IsTokenValidForIndexing(token))
				{
					token = UpdateIndexTableFromToken(token,topic);
				}
				token = token.next;
			}
		}
	}
}

function UpdateIndexTableFromToken(token,topic)
{
	//we know that for this tag we have to add all the text as index entry
	//the next one should be the text one
	token = token.next;
	if(token.tokenType == RoboHelp.TokenType.TOKENTEXT)
	{
		var indexText = token.name;
		AddIndex(indexText,topic);
		token.next;
	}
	return token;
}

function FindIndexinArray(indexText)
{
	for(var index=0;index<indexArray.length;index++)
	{
		var temp = indexArray[index].index;
		if(temp==indexText)
			return index;
	}
	return -1;
}

function AddIndex(indexText,topic)
{
	//we have to find if there is already a index with this name in the array or not
	outputMsg('\t \tAdding Index       '+indexText+'\n');
	var index = FindIndexinArray(indexText);
	if(index!=-1)
	{
		//we found a index entry already there.
		var topicArray = indexArray[index].topics;
		//check if the topic is already present or not
		if(!IsTopicPresentInTopicArray(topicArray,topic))
			topicArray[topicArray.length]=topic;
	}
	else
	{
		var newIndexObject = new Object();
		newIndexObject.index = indexText;
		var topicArray = new Array();
		topicArray[0] = topic;
		newIndexObject.topics = topicArray;
		indexArray[indexArray.length]=newIndexObject;
	}
}

function AppendIndexToFile(indexEntry,file)
{
	var indexText = EscapeForXML(indexEntry.index);
	var strLine = '';
	strLine = '\t<item name="'+indexText+'" >\n';
	file.write(strLine);
	//now for each topic entry
	var topicArray = indexEntry.topics;
	var topicTitle,topicPath;
	if(typeof(topicArray)!='undefined')
	{
		for(var count=0;count<topicArray.length;count++)
		{
			topicTitle = EscapeForXML(topicArray[count].name);
			topicPath = EscapeForXML(GetRelativePath(topicArray[count].path));
			strLine = '\t\t<section name="'+topicTitle+'" link="'+topicPath+'" />\n';
			file.write(strLine);
		}
	}
	strLine = '\t</item>\n';
	file.write(strLine);
}
function UpdateIndexFile()
{
	//in this file we will create a new index file for that
	var indexManager = RoboHelp.project.IndexManager;
	//try to get the index already there
	var indexObject=null;
	var count;
	indexObject = indexManager.newItem(newIndexFileName);
	var indexFilePath = '';
	if(indexObject!=null)
	{
		indexFilePath = indexObject.path;
	}
	else
	{
		//this might be the default index, so try to emulate the behavior
		indexFilePath = RoboHelp.project.path+'\\'+newIndexFileName+'.hhk';
	}
	//we will create this file from scratch and write all the index entry ourself
	var file = new File(indexFilePath);
	file.open("w");
	var strLine = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<index version=\"1.0\">\n<properties></properties>\n";
	file.write(strLine);
//now for each index entry we need to add the line
	for(count=0;count<indexArray.length;count++)
	{
		AppendIndexToFile(indexArray[count],file);
	}
	strLine = "</index>\n";
	file.write(strLine);
	file.close();
}

function GetRelativePath(topicPath)
{
	var projectpath = RoboHelp.project.path;
	var index = topicPath.indexOf(projectpath);
	if(index==0)
	{
		topicPath = topicPath.substr(projectpath.length+1);
	}
	else
	{
		alert('error check here');
	}
	return topicPath;
}
//this is the function which tells which style we need to check for adding to index list or not
function IsTokenValidForIndexing(token)
{
	var bValid= false;
	//this is the function which tell which all token are required for indexing
	var tokenName = token.name.toLowerCase();
	for(var index=0;index<styleArray.length;index++)
	{
		if(tokenName== styleArray[index])
		{
			bValid = true;
			break;
		}
	}
	return bValid;
}
function IsTopicPresentInTopicArray(topicArray,topic)
{
	var bPresent = false;
	for(var index=0;index<topicArray.length;index++)
	{
		if(topic == topicArray[index])
		{
			bPresent = true;
			break;
		}
	}
	return bPresent;
}
function CloseAndReopen()
{
	var projectpath = RoboHelp.project.path+'\\'+RoboHelp.project.name+'.xpj';
	RoboHelp.closeProject();
	RoboHelp.openProject(projectpath);
}

function ReplaceString(szStringToBeReplaced,szStringToSearch,szStringToReplace)
{
	var myPattern= new RegExp(szStringToSearch,"gi");  
	return szStringToBeReplaced.replace(myPattern,szStringToReplace);
}

function EscapeForXML(szTemp)
{
	if(szTemp.length>0)
	{
		szTemp = ReplaceString(szTemp,"&","&amp;");
		szTemp = ReplaceString(szTemp,"<","&lt;");
		szTemp = ReplaceString(szTemp,"\"","&quot;");
		szTemp = ReplaceString(szTemp,">","&gt;");
		szTemp = ReplaceString(szTemp,"'","&apos;");
	}
	return szTemp;
}
